---
description: "Learn more about: Table.FillDown"
title: "Table.FillDown"
---
# Table.FillDown

## Syntax

<pre>
Table.FillDown(<b>table</b> as table, <b>columns</b> as list) as table
</pre>

## About

Returns a table from the `table` specified where the value of a previous cell is propagated to the null-valued cells below in the `columns` specified.

## Example 1

Return a table with the null values in column [Place] filled with the value above them from the table.

**Usage**

```powerquery-m
Table.FillDown(
    Table.FromRecords({
        [Place = 1, Name = "Bob"],
        [Place = null, Name = "John"],
        [Place = 2, Name = "Brad"],
        [Place = 3, Name = "Mark"],
        [Place = null, Name = "Tom"],
        [Place = null, Name = "Adam"]
    }),
    {"Place"}
)
```

**Output**

```powerquery-m
Table.FromRecords({
    [Place = 1, Name = "Bob"],
    [Place = 1, Name = "John"],
    [Place = 2, Name = "Brad"],
    [Place = 3, Name = "Mark"],
    [Place = 3, Name = "Tom"],
    [Place = 3, Name = "Adam"]
})
```
